## Google SRE

### 一、SRE 与 DevOps

DevOps

![devops 含义 - Google Search 2019-10-24 10-37-45](http://limbo.oss-cn-beijing.aliyuncs.com/2019-10-24-030239.png)

**CALMS** 哲学可参考[实例化DevOps原则](https://insights.thoughtworks.cn/instantiate-the-principles-of-devops/) 解析

DevOps背景

- 事故是正常的：专注于恢复服务比阻止事故发生要更有价值
- 循序渐进的变更：小步快跑，小而频繁变更，持续集成(CI) & 持续交付或部署(CD)
- 工具和文化相关联：工具是DevOps手段，文化要突出，文化的影响力远胜策略
- 度量至关重要

SRE背景：（SRE实现了DevOps描述的哲学）

- 运维是个软件问题：软件工程角度来解决运维问题
- SLOs进行管理：SLO、SLI
- 自动化：减少琐事

### 二、实施SLO

SLO服务可靠性目标定级，是SRE的核心

> SRE的核心职责不仅仅是将“所有的事情”自动化并随时待命处理故障，他们的日常工作都将按照SLO来开展。确保SLO在短期内是合理的，并且可根据情况适时地调整。甚至可以说，如果没有SLO，就没有SRE。

SLO需要**可靠性指标与错误预算** 和 **SLI衡量标准**

- 可靠性指标：N个9（如99.99%) 设置要合理，错误预算=100%-SLO
- SLI：建议SLI为：好的事件数量除以总事件数量

如下API Service定义

![系统可用性度量 - QoS - Confluence 2019-10-24 11-01-53](http://limbo.oss-cn-beijing.aliyuncs.com/2019-10-24-030229.png)

### 四、监控

监控数据源：**指标和日志**

> 指标是属性和事件的数字度量，通常间隔一段固定的时间产生多个数据点。日志是只能追加的事件记录。

X

- 将配置视为代码
- 保持监控系统的组件松耦合（agent、store、alert、UI、等相互独立），如Prometheus 而非Zabbix

### 五、报警SLO

好的SLO可以为on-call人员该如何迅速做出响应提供最准确的提示，将SLO转换为具体报警规则是至关重要的。

**从SLI和错误预算来生成报警，目标：通知重大事件（消耗大部分错误预算的事件）**

### 六、减少琐事

琐事定义：

- 手动性
- 重复性
- 可以被自动化的
- 非技术性的
- 没有持久价值的
- 与服务同步增长的

琐事管理战略

> 任何规模的生产系统，人力管理都是至关重要的。 一旦确定并量化了琐事，就消除它的计划就要提上日程。这个工作可能需要数周才能完成，因此制定一个完善的计划是至关重要。首先，从源头上消除琐事是最佳的解决方案，但是对于源头上无法消除的琐事，必须通过其他方式来消除它

- 从部分自动化开始
- 提高系统一致性，减少差异及认知偏差
- 使用SLO减少琐事
- 反馈并改进
- 提供一种自助的服务方法

消除琐事，考虑成本，识别，设计和实施流程或自动化解决方案都需要投入成本。一旦决定减少琐事，就必确立指标，进行投资回报率（ROI）分析，风险评估和迭代开发来确定是否减少了工作量。

### 七、简单化

大道至简，简单化是SRE的重要目标；衡量系统复杂性可以从下面几个维度：

- 训练时长：新成员多久能参与on-call工作
- 解释时长：在白板上绘制系统架构图并解释各个组件的功能和依赖关系
- 多样性：管理多样性、部署、配置多样性

### 八、On-Call

on-call轮值意味着在某段时间内能随叫随到，随时响应紧急问题;在Google，on-call轮值是SRE的职责之一，在国内的一些互联网公司是DevOps & RD的职责之一。

> 在Google，on-call的目标是在确保不会以牺牲on-call工程师的健康为代价的前提下覆盖到重点服务，保障服务的可靠性

on-call流程要轻量化，不要占用工程师过多时间

故障定级：

- P1：立即处理
  - 立马采取行动
  - 呼叫on-call
  - 是否影响SLO
- P2：下个工作日处理
  - 先周知

### 十三、数据处理管道

SLO

- 数据延迟
  - 以Y [秒，天，分钟]处理的X％数据
  - 最旧的数据不早于Y [秒，天，分钟]
  - 作业在Y [秒，天，分钟]内成功完成
- 数据正确性